<?php

/*
@copyright

Fleet Manager v5.0.0

Copyright (C) 2017-2020 Hyvikk Solutions <https://hyvikk.com/> All rights reserved.
Design and developed by Hyvikk Solutions <https://hyvikk.com/>

 */

namespace App\Http\Requests;

use App\Http\Requests\Request;
use Auth;
use Illuminate\Foundation\Http\FormRequest;

class ExpenseCatRequest extends FormRequest
{
    public function authorize()
    {
        if (Auth::user()->user_type == "S") {
            return true;
        } else {
            abort(404);
        }
    }

    public function rules()
    {
        return [

            'name' => 'required|unique:expense_cat,name,' . \Request::get("id") . ',id,deleted_at,NULL',
        ];
    }
}
