<?php

/*
@copyright

Fleet Manager v5.0.0

Copyright (C) 2017-2020 Hyvikk Solutions <https://hyvikk.com/> All rights reserved.
Design and developed by Hyvikk Solutions <https://hyvikk.com/>

 */

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Kodeine\Metable\Metable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use Metable;
    use SoftDeletes;
    use Notifiable;
    use HasApiTokens;
    protected $dates = ['deleted_at'];
    protected $table = "users";
    protected $metaTable = 'users_meta'; //optional.
    protected $fillable = [
        'name', 'email', 'password', 'user_type', 'group_id', 'api_token',
    ];

    protected $hidden = ['password', 'remember_token', 'api_token'];

    protected function getMetaKeyName()
    {
        return 'user_id'; // The parent foreign key
    }

    public function user_data()
    {
        return $this->hasMany("App\Model\UserData", 'user_id', 'id')->withTrashed();
    }

    public function vehicle_detail()
    {
        return $this->hasMany('App\Model\VehicleModel', 'user_id', 'id')->withTrashed();
    }

    public function driver_vehicle()
    {
        return $this->hasOne("App\Model\DriverVehicleModel", "driver_id", "id");
    }

}
