<?php

/*
@copyright

Fleet Manager v5.0.0

Copyright (C) 2017-2020 Hyvikk Solutions <https://hyvikk.com/> All rights reserved.
Design and developed by Hyvikk Solutions <https://hyvikk.com/>

 */

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Model\ExpCats;
use Auth;
use Illuminate\Http\Request;
use Validator;

class ExpenseCategoriesApiController extends Controller
{

    public function delete(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'id' => 'required|integer',
        ]);
        $errors = $validation->errors();

        if (count($errors) > 0) {
            $data['success'] = "0";
            $data['message'] = implode(", ", $errors->all());
            $data['data'] = "";
        } else {
            $expense = ExpCats::find($request->id);
            if ($expense->type == 'u') {
                $expense->expense()->delete();
                $expense->delete();

                $data['success'] = "1";
                $data['message'] = "Record deleted successfully!";
                $data['data'] = "";
            } else {
                $data['success'] = "0";
                $data['message'] = "Unable to delete expense category, please try again later!";
                $data['data'] = "";
            }
        }
        return $data;
    }

    public function update(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'id' => 'required|integer',
            'name' => 'required|unique:expense_cat,name,' . \Request::get("id") . ',id,deleted_at,NULL',
        ]);

        $errors = $validation->errors();
        if (count($errors) > 0) {
            $data['success'] = "0";
            $data['message'] = implode(", ", $errors->all());
            $data['data'] = "";

        } else {
            $cat = ExpCats::find($request->id);
            if ($cat->type == "u") {
                $cat->name = $request->name;
                $cat->user_id = Auth::id();
                $cat->save();
                $data['success'] = "1";
                $data['message'] = "Expense Category updated successfully!";
                $data['data'] = "";
            } else {
                $data['success'] = "0";
                $data['message'] = "Unable to update expense category, please try again later!";
                $data['data'] = "";
            }

        }
        return $data;
    }

    public function store(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'name' => 'required|unique:expense_cat,name',
        ]);

        $errors = $validation->errors();
        if (count($errors) > 0) {
            $data['success'] = "0";
            $data['message'] = implode(", ", $errors->all());
            $data['data'] = "";

        } else {
            ExpCats::create([
                "name" => $request->name,
                "user_id" => Auth::id(),
                "type" => "u",
            ]);
            $data['success'] = "1";
            $data['message'] = "Expense Category added successfully!";
            $data['data'] = "";
        }
        return $data;
    }

    public function categories()
    {
        $categories = ExpCats::get();
        $details = array();
        foreach ($categories as $cat) {
            $details[] = array(
                'id' => $cat->id,
                'name' => $cat->name,
                'type' => ($cat->type == 'd') ? "Default" : "User Defined",
                'created' => date('Y-m-d', strtotime($cat->created_at)),
                'cat_type' => $cat->type,
            );
        }

        $data['success'] = "1";
        $data['message'] = "Data fetched!";
        $data['data'] = $details;
        return $data;
    }
}
