<?php

/*
@copyright

Fleet Manager v5.0.0

Copyright (C) 2017-2020 Hyvikk Solutions <https://hyvikk.com/> All rights reserved.
Design and developed by Hyvikk Solutions <https://hyvikk.com/>

 */

namespace App\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
class Customers extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (Auth::user()->user_type == "S" || Auth::user()->user_type == "O") {
            return true;
        } else {
            abort(404);
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            //'email' => 'unique:users,email,deleted_at,NULL' . \Request::get("id"),
            'email' => !(empty(\Request::get("id")))? 'required' : Rule::unique('users','email')->whereNull('deleted_at').'|email:rfc,dns|email|regex:/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/',
            'phone' => 'required|numeric', 
            'gender' => 'required',
            // 'address1' => 'required',

        ];
    }
    public function messages()
    {
        return [
            // 'email.required' => 'email must be required',
            'email.unique' => 'email already taken',

        ];
    }
}
