<?php

/*
@copyright

Fleet Manager v5.0.0

Copyright (C) 2017-2020 Hyvikk Solutions <https://hyvikk.com/> All rights reserved.
Design and developed by Hyvikk Solutions <https://hyvikk.com/>

 */

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kodeine\Metable\Metable;

class Bookings extends Model
{
    use Metable;
    use SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $table = "bookings";
    protected $metaTable = 'bookings_meta';
    protected $fillable = [
        'customer_id', 'vehicle_id', 'user_id', 'pickup', 'dropoff', 'pickup_addr', 'dest_addr', 'travellers', 'status', 'comment', 'dropoff_time', 'driver_id', 'note',
    ];

    protected function getMetaKeyName()
    {
        return 'booking_id'; // The parent foreign key
    }

    public function vehicle()
    {
        return $this->hasOne("App\Model\VehicleModel", "id", "vehicle_id")->withTrashed();
    }
    public function customer()
    {
        return $this->hasOne("App\Model\User", "id", "customer_id")->withTrashed();
    }
    public function createdby()
    {
        return $this->hasOne("App\Model\User", "id", "created_by")->withTrashed();
    }
    public function driver()
    {
        return $this->hasOne("App\Model\User", "id", "driver_id")->withTrashed();
    }

    public function user()
    {
        return $this->hasOne("App\Model\User", "id", "user_id")->withTrashed();
    }

    // multivehicle test
    // function test1() {
    //     return $this->hasMany("App\Model\VehicleModel", "id", "v_id")->withTrashed();
    // }
    // function test() {
    //     return $this->belongsTo("App\Model\VehicleModel", "v_id", "id")->withTrashed();
    // }
}
