<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Migration auto-generated by Sequel Pro Laravel Export
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateExpenseTable extends Migration {
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up() {
		Schema::create('expense', function (Blueprint $table) {
			$table->increments('id');
			$table->integer('vehicle_id')->nullable();
			$table->integer('exp_id')->nullable();
			$table->string('type', 10)->default("e");
			$table->double('amount', 10, 2)->default(0.00);
			$table->integer('user_id')->nullable();
			$table->integer('expense_type')->nullable();
			$table->text('comment')->nullable();
			$table->date('date')->nullable();
			$table->nullableTimestamps();
			$table->softDeletes();

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down() {
		Schema::dropIfExists('expense');
	}
}
