<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Migration auto-generated by Sequel Pro Laravel Export
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateIncomeTable extends Migration {
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up() {
		Schema::create('income', function (Blueprint $table) {
			$table->increments('id');
			$table->integer('vehicle_id')->nullable();
			$table->integer('income_id')->nullable();
			$table->double('amount', 10, 2)->default(0.00);
			$table->integer('user_id')->nullable();
			$table->integer('income_cat')->nullable();
			$table->integer('mileage')->nullable();
			$table->date('date')->nullable();
			$table->nullableTimestamps();
			$table->softDeletes();

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down() {
		Schema::dropIfExists('income');
	}
}
