<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Migration auto-generated by Sequel Pro Laravel Export
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateVehiclesTable extends Migration {
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up() {
		Schema::create('vehicles', function (Blueprint $table) {
			$table->increments('id');
			$table->string('make', 255)->nullable();
			$table->string('model', 255)->nullable();
			$table->string('type', 255)->nullable();
			$table->string('year', 255)->nullable();
			$table->integer('group_id')->nullable();
			$table->date('lic_exp_date')->nullable();
			$table->date('reg_exp_date')->nullable();
			$table->string('vehicle_image', 255)->nullable();
			$table->string('engine_type', 255)->nullable();
			$table->string('horse_power', 255)->nullable();
			$table->string('color', 255)->nullable();
			$table->string('vin', 255)->nullable();
			$table->string('license_plate', 255);
			$table->integer('mileage')->nullable();

			$table->tinyInteger('in_service')->default(0)->nullable();
			$table->integer('user_id')->nullable();
			$table->nullableTimestamps();
			$table->softDeletes();
			$table->integer('int_mileage')->nullable();

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down() {
		Schema::dropIfExists('vehicles');
	}
}
