<?php ($date_format_setting=(Hyvikk::get('date_format'))?Hyvikk::get('date_format'):'d-m-Y'); ?>

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active"> <?php echo app('translator')->getFromJson('fleet.fuel'); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
<style type="text/css">
  .checkbox, #chk_all{
    width: 20px;
    height: 20px;
  }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="card card-info">
      <div class="card-header">
        <h3 class="card-title">
          <?php echo app('translator')->getFromJson('fleet.manageFuel'); ?>
          &nbsp;
          <a href="<?php echo e(route('fuel.create')); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('fleet.addNew'); ?></a>
        </h3>
      </div>

      <div class="card-body table-responsive">
        <table class="table" id="data_table">
          <thead class="thead-inverse">
            <tr>
              <th>
                <?php if($data->count() > 0): ?>
                <input type="checkbox" id="chk_all">
                <?php endif; ?>
              </th>
              <th></th>
              <th></th>
              <th><?php echo app('translator')->getFromJson('fleet.date'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.qty'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.cost'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.meter'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.consumption'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.province'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.action'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td>
                <input type="checkbox" name="ids[]" value="<?php echo e($row->id); ?>" class="checkbox" id="chk<?php echo e($row->id); ?>" onclick='checkcheckbox();'>
              </td>
              <td>
                <?php if($row->vehicle_data['vehicle_image'] != null): ?>
                  <img src="<?php echo e(asset('uploads/'.$row->vehicle_data['vehicle_image'])); ?>" height="70px" width="70px">
                <?php else: ?>
                  <img src="<?php echo e(asset("assets/images/vehicle.jpeg")); ?>" height="70px" width="70px">
                <?php endif; ?>
              </td>
              <td>
                <a href="<?php echo e(url("admin/vehicles/".$row->vehicle_id."/edit")); ?>">
                <?php echo e($row->vehicle_data['year']); ?> <?php echo e($row->vehicle_data['make']); ?>-<?php echo e($row->vehicle_data['model']); ?>

                </a>
                <br>
                <b><?php echo app('translator')->getFromJson('fleet.vin'); ?>:</b> <?php echo e($row->vehicle_data['vin']); ?>

              </td>
              <td><?php echo e(date($date_format_setting,strtotime($row->date))); ?></td>
              <td> <?php echo e($row->qty); ?> <?php if(Hyvikk::get('fuel_unit') == "gallon"): ?> <?php echo app('translator')->getFromJson('fleet.gal'); ?> <?php else: ?> Liter <?php endif; ?> </td>
              <td>
                <?php ($total = $row->qty * $row->cost_per_unit); ?>
                <?php echo e(Hyvikk::get('currency')); ?> <?php echo e($total); ?>

                <br>
                <?php echo e(Hyvikk::get('currency')); ?> <?php echo e($row->cost_per_unit); ?>/ <?php echo e(Hyvikk::get('fuel_unit')); ?>

              </td>
              <td>
                <?php echo app('translator')->getFromJson('fleet.start'); ?>: <?php echo e($row->start_meter); ?> <?php echo e(Hyvikk::get('dis_format')); ?>

                <br>
                <?php echo app('translator')->getFromJson('fleet.end'); ?>: <?php echo e($row->end_meter); ?> <?php echo e(Hyvikk::get('dis_format')); ?>

                <br>
                <?php echo app('translator')->getFromJson('fleet.distence'); ?>:

                <?php if($row->end_meter == 0): ?>
                0.00 <?php echo e(Hyvikk::get('dis_format')); ?>

                <?php else: ?>
                <?php echo e($row->end_meter - $row->start_meter); ?>  <?php echo e(Hyvikk::get('dis_format')); ?>

                <?php endif; ?>
              </td>
              <td>
                <?php echo e($row->consumption); ?>

                <?php if(Hyvikk::get('dis_format') == "km"): ?>
                 <?php if(Hyvikk::get('fuel_unit') == "gallon"): ?>KMPG <?php else: ?> KMPL <?php endif; ?>
                <?php else: ?>
                 <?php if(Hyvikk::get('fuel_unit') == "gallon"): ?>MPG <?php else: ?> MPL <?php endif; ?>
                <?php endif; ?>
              </td>
              <td>
                <?php echo e($row->province); ?>

              </td>
              <td>
              <div class="btn-group">
                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                  <span class="fa fa-gear"></span>
                  <span class="sr-only">Toggle Dropdown</span>
                </button>
                <div class="dropdown-menu custom" role="menu">
                  <a class="dropdown-item" href="<?php echo e(url("admin/fuel/".$row->id."/edit")); ?>"> <span aria-hidden="true" class="fa fa-edit" style="color: #f0ad4e;"></span> <?php echo app('translator')->getFromJson('fleet.edit'); ?></a>
                  <a class="dropdown-item" data-id="<?php echo e($row->id); ?>" data-toggle="modal" data-target="#myModal"><span aria-hidden="true" class="fa fa-trash" style="color: #dd4b39"></span> <?php echo app('translator')->getFromJson('fleet.delete'); ?></a>
                </div>
              </div>
              <?php echo Form::open(['url' => 'admin/fuel/'.$row->id,'method'=>'DELETE','class'=>'form-horizontal','id'=>'form_'.$row->id]); ?>

              <?php echo Form::hidden("id",$row->id); ?>

              <?php echo Form::close(); ?>

              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
          <tfoot>
            <tr>
              <th>
              <?php if($data->count() > 0): ?>
                <button class="btn btn-danger" id="bulk_delete" data-toggle="modal" data-target="#bulkModal" disabled><?php echo app('translator')->getFromJson('fleet.delete'); ?></button>
              <?php endif; ?>
              </th>
              <th></th>
              <th></th>
              <th><?php echo app('translator')->getFromJson('fleet.date'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.qty'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.cost'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.meter'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.consumption'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.province'); ?></th>
              <th><?php echo app('translator')->getFromJson('fleet.action'); ?></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div id="bulkModal" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title"><?php echo app('translator')->getFromJson('fleet.delete'); ?></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <?php echo Form::open(['url'=>'admin/delete-fuel','method'=>'POST','id'=>'form_delete']); ?>

        <div id="bulk_hidden"></div>
        <p><?php echo app('translator')->getFromJson('fleet.confirm_bulk_delete'); ?></p>
      </div>
      <div class="modal-footer">
        <button id="bulk_action" class="btn btn-danger" type="submit" data-submit=""><?php echo app('translator')->getFromJson('fleet.delete'); ?></button>
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->getFromJson('fleet.close'); ?></button>
      </div>
        <?php echo Form::close(); ?>

    </div>
  </div>
</div>
<!-- Modal -->

<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title"><?php echo app('translator')->getFromJson('fleet.delete'); ?></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <p><?php echo app('translator')->getFromJson('fleet.confirm_delete'); ?></p>
      </div>
      <div class="modal-footer">
        <button id="del_btn" class="btn btn-danger" type="button" data-submit=""><?php echo app('translator')->getFromJson('fleet.delete'); ?></button>
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->getFromJson('fleet.close'); ?></button>
      </div>
    </div>
  </div>
</div>
<!-- Modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">
  $("#del_btn").on("click",function(){
    var id=$(this).data("submit");
    $("#form_"+id).submit();
  });

  $('#myModal').on('show.bs.modal', function(e) {
    var id = e.relatedTarget.dataset.id;
    $("#del_btn").attr("data-submit",id);
  });

  $('input[type="checkbox"]').on('click',function(){
    $('#bulk_delete').removeAttr('disabled');
  });

  $('#bulk_delete').on('click',function(){
    // console.log($( "input[name='ids[]']:checked" ).length);
    if($( "input[name='ids[]']:checked" ).length == 0){
      $('#bulk_delete').prop('type','button');
        new PNotify({
            title: 'Failed!',
            text: "<?php echo app('translator')->getFromJson('fleet.delete_error'); ?>",
            type: 'error'
          });
        $('#bulk_delete').attr('disabled',true);
    }
    if($("input[name='ids[]']:checked").length > 0){
      // var favorite = [];
      $.each($("input[name='ids[]']:checked"), function(){
          // favorite.push($(this).val());
          $("#bulk_hidden").append('<input type=hidden name=ids[] value='+$(this).val()+'>');
      });
      // console.log(favorite);
    }
  });


  $('#chk_all').on('click',function(){
    if(this.checked){
      $('.checkbox').each(function(){
        $('.checkbox').prop("checked",true);
      });
    }else{
      $('.checkbox').each(function(){
        $('.checkbox').prop("checked",false);
      });
    }
  });

  // Checkbox checked
  function checkcheckbox(){
    // Total checkboxes
    var length = $('.checkbox').length;
    // Total checked checkboxes
    var totalchecked = 0;
    $('.checkbox').each(function(){
        if($(this).is(':checked')){
            totalchecked+=1;
        }
    });
    // console.log(length+" "+totalchecked);
    // Checked unchecked checkbox
    if(totalchecked == length){
        $("#chk_all").prop('checked', true);
    }else{
        $('#chk_all').prop('checked', false);
    }
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/fleet/framework/resources/views/fuel/index.blade.php ENDPATH**/ ?>